function openModal(profile) {
    const modal = document.getElementById('modal');
    const modalImg = document.getElementById('modal-img');
    const modalName = document.getElementById('modal-name');
    const modalDesc = document.getElementById('modal-desc');

    // Haal de gegevens op uit het aangeklikte profiel
    const name = profile.getAttribute('data-name');
    const img = profile.getAttribute('data-img');
    const desc = profile.getAttribute('data-desc');

    // Vul de modal met de profielgegevens
    modalImg.src = img;
    modalImg.alt = name;
    modalName.textContent = name;
    modalDesc.textContent = desc;

    // Toon de modal
    modal.style.display = "flex";
}

function closeModal() {
    document.getElementById('modal').style.display = "none";
}

// Sluit de modal als er buiten de modal-content wordt geklikt
window.onclick = function(event) {
    const modal = document.getElementById('modal');
    if (event.target == modal) {
        modal.style.display = "none";
    }
}
