var body = document.getElementsByTagName("body")
var style = window.getComputedStyle(body[0]);
var size = Math.floor(Math.min(window.innerHeight / 16, window.innerWidth / 16));

var colorPalettes = [
    ['#ffcc00', '#670305', '#fc3232'],
    ['#f9aecd', '#fa339c', '#78034a'],
    ['#beb0ff', '#9535f9', '#69197c'],
    ['#56ddf0', '#0050ff', '#03357c'],
    ['#c0ed0c', '#2add5d', '#014c35']
];

var root = document.querySelector(":root");
var palette;
var sectionCount = 4;
var currentSection = 0;

var background = {
    canvas: document.createElement("canvas"),
    start: function () {
        this.canvas.height = window.innerHeight;
        this.canvas.width = window.innerWidth;
        this.context = this.canvas.getContext("2d");
        document.body.insertBefore(this.canvas, document.body.childNodes[0]);
        changeThemes(getRandomInt(5));
        for (var i = 0; i < 200; i++) {
            updateArea();
        }
        this.interval = setInterval(updateArea, 1000);
        this.interval = setInterval(updateArea, 3500);
        this.interval = setInterval(updateArea, 800);
    },
    clear: function () {
        this.context.clearRect(0, 0, this.canvas.width, this.canvas.height);
    }
}

function updateArea() {
    ctx = background.canvas.getContext("2d");
    x = Math.floor(getRandomInt(9) * (window.innerWidth / 9) + window.innerWidth / 32);
    y = Math.floor(getRandomInt(9) * (window.innerHeight / 9) + window.innerHeight / 32);
    color = palette[getRandomInt(3)];
    ctx.fillStyle = color;
    ctx.beginPath();
    ctx.rect(x, y, size, size)
    ctx.fill();
}

function changeThemes(number) {
    palette = colorPalettes[number];
    root.style.setProperty('--primary', palette[0]);
    root.style.setProperty('--secondary', palette[1]);
    root.style.setProperty('--tetriary', palette[2]);

    background.clear();
    for (var i = 0; i < 200; i++) {
        updateArea();
    }
}

function getRandomInt(max) {
    return Math.floor(Math.random() * max);
}



function ChangeSection() {
    var home = document.getElementById("home");
    var firstYear = document.getElementById("firstYear");
    var blocks = document.getElementById("blocks");
    var schedule = document.getElementById("schedule");

    if (currentSection == 0) {
        home.style.display = "block";
        firstYear.style.display = "none";
        blocks.style.display = "none";
        schedule.style.display = "none";
    }
    if (currentSection == 1) {
        home.style.display = "none";
        firstYear.style.display = "block";
        blocks.style.display = "none";
        schedule.style.display = "none";
    }
    if (currentSection == 2) {
        home.style.display = "none";
        firstYear.style.display = "none";
        blocks.style.display = "block";
        schedule.style.display = "none";
    }
    if (currentSection == 3) {
        home.style.display = "none";
        firstYear.style.display = "none";
        blocks.style.display = "none";
        schedule.style.display = "block";
    }
}

function Next() {
    if (currentSection < sectionCount - 1) {
        StartAnim();
        setTimeout(function () {
            currentSection += 1;
            ChangeSection();
        }, 700);
    }
}

function Previous() {
    if (currentSection > 0) {
        StartAnim("reverse");
        setTimeout(function () {
            currentSection -= 1;
            ChangeSection();
        }, 700);
    }
}

function Home() {
    if (currentSection <= sectionCount - 1) {
        StartAnim();
        setTimeout(function () {
            currentSection = 0;
            ChangeSection();
        }, 700);
    }
}

function FirstYear() {
    if (currentSection <= sectionCount - 1) {
        StartAnim();
        setTimeout(function () {
            currentSection = 1;
            ChangeSection();
        }, 700);
    }
}

function Blocks() {
    if (currentSection <= sectionCount - 1) {
        StartAnim();
        setTimeout(function () {
            currentSection = 2;
            ChangeSection();
        }, 700);
    }
}

function Schedule() {
    if (currentSection <= sectionCount - 1) {
        StartAnim();
        setTimeout(function () {
            currentSection = 3;
            ChangeSection();
        }, 700);
    }
}

function StartAnim(reverse) {
    var main = document.getElementById("main");
    var buttons = document.getElementsByClassName("sectionButton");

    for (var button of buttons) {
        button.disabled = true;
    }

    if (reverse != undefined) {
        main.classList += "swapAnimationReverse";
    }
    else{
        main.classList += "swapAnimation";
    }
    window.setTimeout(StopAnim, 1600);
}

function StopAnim() {
    main.classList = ""
    var buttons = document.getElementsByClassName("sectionButton");
    for (var button of buttons) {
        button.disabled = false;
    }
}

window.setTimeout(background.start(), 1);
