var body = document.getElementsByTagName("body")
var style = window.getComputedStyle(body[0]);
var size = Math.floor(Math.min(window.innerHeight / 16, window.innerWidth / 16));

var colorPalettes = [
    ['#ffcc00', '#670305', '#fc3232'],
    ['#f9aecd', '#fa339c', '#78034a'],
    ['#beb0ff', '#9535f9', '#69197c'],
    ['#56ddf0', '#0050ff', '#03357c'],
    ['#c0ed0c', '#2add5d', '#014c35']
];

var root = document.querySelector(":root");
var palette;

function onload() {
    background.start();
}

var background = {
    canvas: document.createElement("canvas"),
    start: function () {
        this.canvas.height = window.innerHeight;
        this.canvas.width = window.innerWidth;
        this.context = this.canvas.getContext("2d");
        document.body.insertBefore(this.canvas, document.body.childNodes[0]);
        changeThemes(getRandomInt(5));
        for (var i = 0; i < 200; i++) {
            updateArea();
        }
        this.interval = setInterval(updateArea, 1000);
        this.interval = setInterval(updateArea, 3500);
        this.interval = setInterval(updateArea, 800);
    },
    clear: function () {
        this.context.clearRect(0, 0, this.canvas.width, this.canvas.height);
    }
}

function updateArea() {
    ctx = background.canvas.getContext("2d");
    x = Math.floor(getRandomInt(9) * (window.innerWidth / 9) + window.innerWidth / 32);
    y = Math.floor(getRandomInt(9) * (window.innerHeight / 9) + window.innerHeight / 32);
    // console.log(x, y)
    color = palette[getRandomInt(3)];
    ctx.fillStyle = color;
    ctx.beginPath();
    // ctx.arc(x, y, size, 0, 2 * Math.PI);
    ctx.rect(x, y, size, size)
    ctx.fill();
}

function changeThemes(number) {
    palette = colorPalettes[number];
    root.style.setProperty('--primary', palette[0]);
    root.style.setProperty('--secondary', palette[1]);
    root.style.setProperty('--tetriary', palette[2]);

    background.clear();
    for (var i = 0; i < 200; i++) {
        updateArea();
    }
}

function getRandomInt(max) {
    return Math.floor(Math.random() * max);
}