const sections = [
    {
        title: "Het 1<sup>e</sup> jaar",
        anchor: "het-eerste-jaar",
        src: "sections/base/het-eerste-jaar.html",
        colors: {
            text: "#FFCC00",
            background: "#03357C"
        }
    },
    {
        title: "Versnellen?",
        anchor: "versnellen",
        src: "sections/base/versnellen.html",
        colors: {
            "text": "#03357C",
            "background": "#FFCC00"
        }
    },
    {
        src: "sections/base/het-rooster.html"
    },
    {
        title: "Onze Docenten",
        anchor: "onze-docenten",
        src: "sections/base/de-docenten.html",
        colors: {
            text: "#FFCC00",
            background: "#03357C"
        }
    },
    {
        src: "sections/custom/de-sfeer.html"
    },
    {
        src: "sections/custom/samenwerken.html"
    },
    {
        src: "sections/custom/wat-vind-ik.html"
    }
]

const navigationContainer = document.querySelector("#section-navigation");
const contentContainer = document.querySelector("#section-content");

for (const section in sections) {

    const anchor = sections[section].anchor || `section-${section}`;

    /* Content */
    const sectionContainer = document.createElement("section");
    sectionContainer.id = anchor;

    fetch(sections[section].src).then(response => response.text()).then(text => sectionContainer.innerHTML = text);
    contentContainer.appendChild(sectionContainer);

    /* Navigation */
    const title = sections[section].title;
    const colors = sections[section].colors;

    if (!title || !colors) continue;

    const linkItem = document.createElement("a");
    linkItem.classList.add("nav-link-item");

    linkItem.href = `#${anchor}`;
    linkItem.style.color = colors.text;
    linkItem.style.backgroundColor = colors.background;

    const linkHeading = document.createElement("h2");
    linkHeading.classList.add("nav-link-heading");

    linkHeading.innerHTML = title;

    linkItem.appendChild(linkHeading);
    navigationContainer.appendChild(linkItem);
}