var becomeaElement = document.getElementById('become_a');
var typewriter = new Typewriter(becomeaElement, {
    loop: true,
    delay: 125,
});

typewriter.typeString('software developer')
    .pauseFor(2000)
    .deleteAll()
    .typeString('web developer')
    .pauseFor(2000)
    .deleteAll()
    .typeString('full-stack developer')
    .pauseFor(2000)
    .deleteAll()
    .start();

const player = new Plyr('#player');

const questions = [
    {
        question: 'Are you handy with computers?',
        answers: [
            {
                text: 'Yes',
                points: 1
            },
            {
                text: 'No',
                points: 0
            }
        ]
    },
    {
        question: 'Can you work well together in a team?',
        answers: [
            {
                text: 'Yes',
                points: 1
            },
            {
                text: 'No',
                points: 0
            }
        ]
    },
    {
        question: 'Are you able to think logically?',
        answers: [
            {
                text: 'Yes',
                points: 1
            },
            {
                text: 'No',
                points: 0
            }
        ]
    },
    {
        question: 'Do you want to be able to work flexibly?',
        answers: [
            {
                text: 'Yes',
                points: 1
            },
            {
                text: 'No',
                points: 0
            }
        ]
    },
    {
        question: 'Are you eager to learn?',
        answers: [
            {
                text: 'Yes',
                points: 1
            },
            {
                text: 'No',
                points: 0
            }
        ],
    },
    {
        question: 'Do you want a good salary?',
        answers: [
            {
                text: 'Yes',
                points: 1
            },
            {
                text: 'No',
                points: 0
            }
        ]
    }
]

async function startQuiz() {
    $('#quiz').modal('show')

    const quizContent = document.getElementById('quiz-content')
    quizContent.innerHTML = '';

    for (const question of questions) {
        const index = questions.indexOf(question);
        let questionElement = await createQuizQuestion(question, index + 1)
        quizContent.appendChild(questionElement)
    }

    let calculateButton = document.createElement('button');
    calculateButton.classList.add('btn');
    calculateButton.classList.add('btn-dark');
    calculateButton.style.width = '100%';
    calculateButton.innerHTML = 'Bereken resultaat';
    calculateButton.onclick = calculateQuizResult;

    quizContent.appendChild(calculateButton);
}

let quizPoints = [];
async function changeQuizPoints(question, point) {
    quizPoints[question] = point;
}

async function calculateQuizResult() {
    let totalPoints = 0;
    quizPoints.forEach(point => {
        totalPoints += point;
    })

    const quizContent = document.getElementById('quiz-content')

    if(totalPoints >= 3) {
        document.getElementById('quiz_confetti_box').style.display = 'block';
        quizContent.innerHTML = `
        <div class="text-center">
            <h1>Gefeliciteerd!</h1>
            <p>Volgens deze quiz ben je geschikt voor deze opleiding, het blijft natuurlijk je eigen keuze.</p>
            <p><b>Informeer bij docenten, of studenten van deze opleiding, om echt te kijken of deze opleiding iets voor jou is.</b></p>
        </div>`
    } else {
        quizContent.innerHTML = `
        <div class="text-center">
            <p>Volgens de antwoorden die je hebt gegeven op deze quiz is dit niet een opleiding die bij je eigenschappen past, maar zegt natuurlijk niet dat je deze kan leren. Het blijft je eigen keuze.</p>
            <p><b>Informeer bij docenten, of studenten van deze opleiding, om echt te kijken of deze opleiding iets voor jou is.</b></p>
        </div>`
    }

    setTimeout(function () {
        document.getElementById('quiz_confetti_box').style.display = 'none';
    }, 2500)
}

async function createQuizQuestion(question, index) {
    let questionElement = document.createElement('div');
    questionElement.classList.add('row');
    questionElement.classList.add('mb-3');

    let questionId = index;
    let answerElements = ``;

    question.answers.forEach((answer, index) => {
        let answerElement = document.createElement('div');
        answerElement.classList.add('form-check');

        answerElement.innerHTML = `
            <input class="form-check-input" type="radio" name="question_${questionId}" id="question_${questionId}" onclick="changeQuizPoints(${questionId}, ${answer.points})">
            <label class="form-check-label" for="question_${questionId}">
                ${answer.text}
            </label>`

        answerElements += answerElement.outerHTML;
    })

    questionElement.innerHTML = `<div class="col-lg-8">
                        <b>${index}.</b> <span>${question.question}</span>
                    </div>
                    <div class="col-lg-4">
                        ${answerElements}
                    </div>`

    return questionElement;
}

async function stopQuiz() {
    $('#quiz').modal('hide')
}